within TestLibrary.Models.ModelContainer1;

package Model1

encapsulated type States = enumeration(
	S1,
	X1,
	S2);

encapsulated type Composites = enumeration(
	C1,
	C2);

encapsulated type Species = enumeration(
	SP1);


class SubModel1 "SubModel1"
	Real states[States] "State variable concentrations";

	parameter Real S2 = 0.0;
	parameter Real S1 = 120.0;
	parameter Real X1 = 40.0;

equation
	states[States.S2] = S2;
	states[States.S1] = S1;
	states[States.X1] = X1;
end SubModel1;


class Parameters
	parameter Real p1 = 6.0;
	parameter Real p2 = 0.62;
	parameter Real K_S1 = 20.0;
	parameter Real K_S2 = 0.2;
	parameter Real p3 = 0.67;
end Parameters;


class SubModel2 "SubModel2"

	Real states[States];
	Parameters parameters;

	parameter Real S2_0 = 5.0;
	parameter Real S1_0 = 30.0;
	parameter Real X1_0 = 50.0;

	type Processes = enumeration(
		proc1,
		proc2);

	Real processRate[Processes] "Process rates";
	Real rate[States] "Blah";

	Real S1_s;
	Real S2_s;

	constant States S1 = States.S1;
	constant States X1 = States.X1;
	constant States S2 = States.S2;

	constant Processes proc1 = Processes.proc1;
	constant Processes proc2 = Processes.proc2;

initial equation
	states[S2] = S2_0;
	states[S1] = S1_0;
	states[X1] = X1_0;

equation
	S1_s = states[S1]/(parameters.K_S1 + states[S1]);
	S2_s = states[S2]/(parameters.K_S2 + states[S2]);
	processRate[proc1] = parameters.p1*S2_s*S1_s*states[X1];
	processRate[proc2] = parameters.p2*states[X1];

	rate[S2] = -(1-parameters.p3)/parameters.p3*processRate[proc1];
	rate[S1] = -1/parameters.p3*processRate[proc1];
	rate[X1] = processRate[proc1] - processRate[proc2];

end SubModel2;


class SubModel3
	Parameters parameters;
	Real states[States];
	Real composites[Composites];

	constant States S1 = States.S1;
	constant States X1 = States.X1;
	constant States S2 = States.S2;

	constant Composites C1 = Composites.C1;
	constant Composites C2 = Composites.C2;

equation
	composites[C1] = states[S1] + states[X1];
	composites[C2] = states[S1] + states[X1];
end SubModel3;


class SubModel4
	Parameters parameters;
	Real states[States];
	Real species[Species];

	constant Species SP1 = Species.SP1;

equation
	species[SP1] = 7.0;
end SubModel4;


connector SubModel5
	flow Real Q;
	Real states[States] "State variable concentrations";
	Real composites[Composites] "Composite variable concentrations";
	Real species[Species] "Ionic species";
end SubModel5;

end Model1;
